	.IDENT	RLOAD
	.LOC	8000H
	.PABS
	.PHEX

;SET UP BYTES FOR COLECO USE
	.BYTE	55H,0AAH,2BH,70H,0,40H,0ABH,70H,0D3H,70H,24H,80H
	JMP	7003H	;RST	1
	JMP	7006H	;RST	2
	JMP	7009H	;RST	3
	JMP	700CH	;RST	4
	JMP	700FH	;RST	5
	JMP	7012H	;RST	6
	JMP	7015H	;RST	7
	JMP	7000H	;NMI

	.LOC	8024H

	LXI	SP,STACK
	CALL	8150	;TURN OFF SOUND
	LXI	H,0
	LXI	D,4000H
	XRA	A
	CALL	1F82H	;CLR ALL SCREEN MEMORY
	CALL	1F85H	;SET UP REGISTERS
	LXI	B,0F04H
	CALL	1FD9H	;REG15,4:B=15:C=4
	CALL	1F7FH
	CALL	1A69H
MESSAG:	LXI	H,TABLE
	LXI	Y,32*8
	LXI	D,0
	MVI	A,2
	CALL	1FBEH
	LXI	H,RECEV	;SET UP THE STACK...
	PUSH	H	;JUST IN CASE THEY SEND DATA.
LOP:	MVI	H,0	;KEYPAD 0
	CALL	11AAH	;GET KEYPAD VALUE
	MOV	A,L	;GET VALUE
	CPI	15	;WAS A KEY HIT ?
	JRNZ	LOP1	;KEY PRESSED
	IN	0FFH	;IS THERE ANY..
	ANI	64	;DATA AVAILABLE AT THE SERIAL PORT ?
	JRNZ	LOP	;NO
	JRZ	LUUP1	;YES
LOP1:	POP	H	;THEY DIDN'T SEND DATA...RID OF IT
	PUSH	PSW	;SAVE VALUE
	CALL	CLS	;CLEAR SCRN
	POP	PSW	;GET VALUE
	CPI	2	;BUTTON 2 ?
	JZ	RUN
	CPI	3	;BUTTON 3 ?
	JZ	MON
	CPI	4	;BUTTON 4 ?
	JZ	JOYSTK
	CPI	5	;BUTTON 5 ?
	JZ	KEYBRD
	CPI	6	;BUTTON 6 ?
	JZ	LABRO
	LXI	D,96	;"WAITING FOR DATA.."
	LXI	H,WAIT
	LXI	Y,22
	MVI	A,2
	CALL	1FBEH
	CALL	SETBIT	;GET BIT RATE
	JMPR	RECEV
SETBIT:	OUT	0C0H	;SWITCH IN JOYSTICKS
	LDA	POS	;WASTE..
	LDA	POS	;SOME..
	LDA	POS	;TIME..
LOOP:	IN	0FFH	;GET 2ND JOYSTICK CONTROLS
	ANI	64	;MASK OFF DATA BIT
	JRNZ	LOOP	;NO DATA
LUUP1:	LXI	H,0	;PREPARE HL
LUUP2:	IN	0FFH	;RECEIVED START BIT, WAIT FOR TIMING PULSE
	ANI	64	;MASK OFF DATA BIT
	JRZ	LUUP2	;NOT YET
LUUP3:	IN	0FFH	;HAVE RECEIVED TIMING BIT, NOW COUNT LENGTH
	CMP	L
	ANI	64	;MASK DATA BIT
	INX	H	;INCREMENT COUNT
	PUSH	H
	POP	H	;WASTE TIME
	JNZ	LUUP3	;KEEP COUNTING
	MOV	A,H
	ORA	A
	JRNZ	LUUP4
	MOV	A,L
	CPI	20H	;IS IT LESS THAN 20H ?
	JNC	LUUP4	;NO
	DCR	L
LUUP4:	SHLD	STORE	;SAVE TIMING BIT VALUE
LUUP5:	IN	0FFH	;WAIT UNTIL THIS CHARACTER IS GONE
	ANI	64
	JRZ	LUUP5	;IT'S NOT GONE YET
	RET
RECEV:	CALL	CLS	;CLR SCRN
	LXI	D,96	;"++ RECEIVING DATA ++"
	LXI	H,REC
	LXI	Y,23
	MVI	A,2
	CALL	1FBEH
	CALL	WAIT4	;GET STATUS BYTE
	MOV	A,C
	STA	STATUS	;SAVE STATUS BYTE
	CALL	WAIT4	;GET LOW MEM ADDRESS
	MOV	L,C
	PUSH	H	;SAVE LOW MEM ADRS
	CALL	WAIT4	;GET HIGH MEM ADRS
	POP	H
	MOV	H,C	;HL NOW HOLDS TRANSFER START ADRS
	PUSH	H	;SAVE RAM POINTER
	SHLD	START	;SAVE START ADRS
	LDA	STATUS	;GET STATUS
	ORA	A	;IS IT A ZERO ?
	JRZ	RECE4	;YES
	CALL	WAIT4	;GET LOW MEM END ADRS
	MOV	L,C
	PUSH	H	;SAVE	LOW MEM END ADRS
	CALL	WAIT4	;GET HIGH MEM END ADRS
	POP	H
	MOV	H,C	;HL NOW HOLDS TRANSFER END ADRS
	SHLD	END	;SAVE END ADRS
RECE4:	POP	H	;GET RAM MEMORY POINTER
	PUSH	H
	MOV	M,C	;SAVE BYTE
	MOV	A,M	;CHECK TO SEE IF THIS IS RAM
	CMP	C	;IS IT ?
	JRZ	RECE5	;YES

	CALL	CLS
	LXI	D,0	;"++ THE RAM POINTER SPECIFIED ++ "
	LXI	H,NRAM	;"  ++ DOESN'T POINT TO RAM. ++"
	LXI	Y,61
	JRZ	PGRTT

RECE5:	CALL	WAIT4	;GET A BYTE
	POP	H	;GET RAM MEMORY ADDRESS
	MOV	M,C	;SAVE BYTE
	MOV	A,M	;CHECK TO SEE IF THIS IS STILL RAM
	CMP	C	;HAVE WE RUN OUT OF RAM ?
	JRZ	RECC5	;NO

	CALL	CLS
	LXI	D,1	;"+++ PROGRAM TO BIG FOR RAM +++"
	LXI	H,PRGTB
	LXI	Y,30
PGRTT:	MVI	A,2
	CALL	1FBEH
PGRTB:	JMPR	PGRTB

RECC5:	LDA	STATUS
	ORA	A
	JRZ	RECE6
	LDED	END
	CALL	CPIDH	;IS THIS ALL THE DATA ?
	JRNZ	RECE6	;NO
RUN:	LHLD	START	;GET RAM START ADRS
	PCHL		;RUN RAM ROUTINE
RECE6:	INX	H
	PUSH	H	;SAVE RAM POINTER
	JMP	RECE5	;GO GET ANOTHER BYTE

;*** GET A SOFTWARE UART BYTE ***
;*** (CALLED AFTER SYNC BYTE RECEIVED)
WAIT4:	MVI	B,8	;RECEIVE A CHARACTER ROUTINE
	LXI	H,POWER
WAIT5:	IN	0FFH	;WAIT FOR START BIT
	ANI	64
	JRNZ	WAIT5	;KEEP WAITING
	LDED	STORE	;GET BIT VALUE
WAIT6:	DCX	D	;DELAY ROUTINE (81 CLK CYCLES)
	PUSH	H
	POP	H	;WASTE TIME
	PUSH	H
	POP	H
	DCR	M
	DCR	A
	MOV	A,D	;DOES...
	ORA	E	;DE = 0 ?
	JNZ	WAIT6	;NO
WAIT7:	IN	0FFH	;GET BIT LEVEL
	ANI	64	;MASK BIT
	MOV	M,A
	INX	H
	LDED	STORE	;GET BIT VALUE
WAIT8:	DCX	D	;DELAY ROUTINE (54 CLK CYCLES)
	PUSH	H
	POP	H	;WASTE TIME
	ANA	M
	DCR	A
	MOV	A,D	;DOES...
	ORA	E	;DE = 0 ?
	JNZ	WAIT8	;NO
	DCR	B	;IS THAT ALL THE BITS ?
	JRNZ	WAIT7	;NO
	LXI	H,POWER	;POINT TO BITS
	MVI	D,8	;8 BITS
	MVI	B,1
	MVI	C,0
WAIT9:	MOV	A,M
	INX	H
	ORA	A
	JRZ	WAIT10
	MOV	A,B
	ADD	C
	MOV	C,A	;UPDATE C
WAIT10:	MOV	A,B
	RLC
	MOV	B,A	;DOUBLE B'S VALUE
	DCR	D	;HAVE ALL 8 BITS BEEN PROCESSED ?
	JRNZ	WAIT9	;NO
	RET		;YES

CLJP:	.ASCII	'CALL 1F76H'
JYSTK:	.ASCII	'73EEH    73EFH'
KYPAD:	.ASCII	'73F0H    73F1H'
WAIT:	.ASCII	'    WAITING FOR DATA..'
REC:	.ASCII	'   ++ RECEIVING DATA ++'
PRGTB:	.ASCII	'+++ PROGRAM TO BIG FOR RAM +++'
NRAM:	.ASCII	'++ THE RAM POINTER SPECIFIED ++ '
	.ASCII	'  ++ DOESN''T POINT TO RAM. ++'
TABLE:	.ASCII	'      ********************      '
	.ASCII	'      * 1 - LOAD PROGRAM *      '
	.ASCII	'      * 2 - RAM PROGRAM  *      '
	.ASCII	'      * 3 - MONITOR      *      '
	.ASCII	'      * 4 - JOYSTICKS    *      '
	.ASCII	'      * 5 - KEYBOARD     *      '
	.ASCII	'      * 6 - LABRATORY    *      '
	.ASCII	'      ********************      '

MON:	CALL	SETBIT	;GET BIT RATE
	LXI	H,32
	SHLD	POS	;PUT CURSOR ON 2ND LINE
MON5:	LHLD	POS
	PUSH	H
	CALL	WAIT4	;GET BYTE
	MOV	A,C
	LXI	H,0
	SHLD	POS	;PUT CURSOR AT HOME
	PUSH	PSW
	CALL	INP5	;PRINT BYTE
	POP	PSW
	POP	H
	SHLD	POS	;RESTORE CURSOR
	CALL	HEXO	;PRINT ASCII HEX BYTE
	MVI	A,' '
	CALL	CONOUT	;PRINT A SEPERATING SPACE
	JMPR	MON5

CLS:	LXI	D,768
CLS5:	DCX	D
	PUSH	D
	LXI	H,1744H	;POINTS TO A SPACE
	LXI	Y,1
	MVI	A,2
	CALL	1FBEH	;PRINT A SPC TO SCRN
	POP	D
	MOV	A,D
	ORA	E
	JRNZ	CLS5
	SDED	POS	;RESET CUR POS
	RET

;WILL ? AT POS THE CHAR IN CHAR
CHANGE:	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	A,2
	LXI	Y,1
	LXI	D,CHAR
	LHLD	POS
	XCHG
	CALL	1FBEH
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET

CONOUT:	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	STA	CHAR	;SAVE CHARACTER TO ?
	CPI	8
	JC	POPH	;DON'T ? ANYTHING < THEN 8
	JRZ	CON9
	CPI	10
	JZ	POPH
	CPI	127	;BS?
	JRNZ	CON10
CON9:	LHLD	POS	;IT IS A BACKSPACE
	MVI	A,' '
	STA	CHAR
	CALL	CHANGE
	DCX	H
	SHLD	POS
	JMPR	CON16
CON10:	CPI	13
	JRNZ	CON12
	MVI	A,' '
	STA	CHAR
	LHLD	POS
	PUSH	H
	LXI	D,CHAR
	XCHG
	LXI	Y,1
	MVI	A,2
	CALL	1FBEH
	POP	H
	MOV	A,L
	ANI	1FH
	JRZ	CON121
CON120:	DCR	L
	DCR	A
	JRNZ	CON120
CON121:	LXI	D,32
	DAD	D
	LXI	D,2FFH
	CALL	CPIDH	;IS CUR AT BOTTOM?
	JNC	CON145
	CALL	CLS
	JMPR	CON145
CON12:	MVI	A,2
	LXI	Y,1
	LHLD	POS
	PUSH	H
	LXI	D,CHAR
	XCHG
	CALL	1FBEH
	POP	D
	LXI	H,2FFH	;BOTTOM OF SCREEN
	CALL	CMPDH	;COMPARE HL TO DE
	INX	D
	JNC	CON14
	LXI	D,0
CON14:	XCHG
CON145:	SHLD	POS
	LHLD	POS
	XCHG
	LXI	H,2FFH	;BOTTOM OF SCREEN
	CALL	CMPDH	;COMPARE HL TO DE
	JNC	CON15
	LXI	D,0	;HIT BOTTOM CIRCLE AROUND TO TOP
CON15:	XCHG
CON16:	SHLD	POS	;SAVE CURSOR POSITION
POPH:	POP	H
	POP	D
	POP	B
	POP	PSW
	RET

;COMPARE DE & HL, SET CARRY IF =
CMPDH:	MOV	A,D
	CMP	H
	JRNZ	CDH10
	MOV	A,E
	CMP	L
	JRNZ	CDH10
	STC
	RET
CDH10:	ORA	A
	RET

;COMPARE HL W/ DE
;IF SAME SET Z, IF H > SET C, IF H < RESET C
CPIDH:	MOV	A,D
	CMP	H
	RNZ
	MOV	A,E
	CMP	L
	RET

;SET CARRY IF A = ASCII #
NUMR:	CPI	48
	JC	NUM5
	CPI	58
	JNC	NUM5
	STC
	RET
NUM5:	ORA	A
	RET

HEXO:	MOV	B,A
	RAR
	RAR
	RAR
	RAR
	CALL	HEX1
	CALL	CONOUT
	MOV	A,B
	CALL	HEX1
	CALL	CONOUT
	RET
HEX1:	ANI	0FH
	ADI	'0'
	CPI	'9'+1
	RC
	ADI	7
	RET

LABRO:	MVI	A,98H	;TONE 1 MID-VOL
TONE:	PUSH	PSW
	OUT	255
	MVI	B,255
TONE15:	MVI	A,80H	;TONE 1 FREQ
	OUT	255
	MOV	A,B
	OUT	255
	DCR	B
	JRNZ	TONE15
	POP	PSW
	DCR	A
	JMPR	TONE

KEYBRD:	MVI	A,91H
	OUT	255
	MVI	A,0B1H
	OUT	255
	MVI	A,0D1H
	OUT	255
	MVI	A,80H
	OUT	255
LOOP3:	MVI	H,0	;KEYPAD 0
	CALL	11AAH	;GET VALUE OF KEYPAD
	MOV	A,L	;GET VALUE
	CPI	15	;WAS A KEY PRESSED?
	JRZ	LOOP3	;NO
	CPI	10	;WAS * PRESSED ?
	JRNZ	LOOP4	;NO
	MVI	A,80H
	JMPR	LOOP8
LOOP4:	CPI	11	;WAS # PRESSED ?
	JRNZ	LOOP5	;NO
	MVI	A,0C0H
	JMPR	LOOP8
LOOP5:	ORA	A	;WAS 0 PRESSED ?
	JRNZ	LOOP6	;NO
	MVI	A,0A0H
	JMPR	LOOP8
LOOP6:	RLC
	RLC
	RLC
LOOP8:	OUT	255
	JMPR	LOOP3

JOYSTK:	LXI	D,11	;"CALL 1F76H"
	LXI	H,CLJP
	LXI	Y,10
	MVI	A,2
	CALL	1FBEH
	LXI	D,72	;"73EEH    73EFH"
	LXI	H,JYSTK
	LXI	Y,14
	MVI	A,2
	CALL	1FBEH
	LXI	D,168	;"73F0H    73F1H"
	LXI	H,KYPAD
	LXI	Y,14
	MVI	A,2
	CALL	1FBEH
JOY1:	CALL	1F76H
	LXI	H,103
	SHLD	POS
	LDA	73EEH
	CALL	INP5
	MVI	A,' '
	CALL	CONOUT
	LDA	73EFH
	CALL	INP5
	LXI	H,199
	SHLD	POS
	LDA	73F0H
	CALL	INP5
	MVI	A,' '
	CALL	CONOUT
	LDA	73F1H
	CALL	INP5
	JMPR	JOY1

INP5:	MOV	L,A
	MVI	B,8
INP8:	ANI	80H
	CZ	INP10
	CNZ	INP11
	MOV	A,L
	RLC		;ROTATE A LEFT
	MOV	L,A
	DCR	B
	JRNZ	INP8
	RET

INP10:	PUSH	PSW
	MVI	A,'0'
	CALL	CONOUT
	POP	PSW
	RET
INP11:	PUSH	PSW
	MVI	A,'1'
	CALL	CONOUT
	POP	PSW
	RET

;***** RAM ASSIGNMENTS *****

	.LOC	7018H
POS:	.WORD	0
STATUS:	.BYTE	0
START:	.WORD	0
END:	.WORD	0
STORE:	.WORD	0
CHAR:	.BYTE	80
POWER:	.BLKB	80
STACK:	.BYTE	0

	.END
